*******************************************************************************
*                      68000/68010 Grundprogramm grafgdp                      *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                           Grafik-Paket fr GDP                              *
*******************************************************************************


gr1p0:                          * Punkt setzen
 move d2,d7                     * d1.w = X / d2.w = Y
 bsr grmoveto                   * Positionieren
 move.b #$80,gdp.w              * Befehl fr Punkt zeichnen
 move d7,d2
 rts

gr1p1:                          * Linie zeichnen
 movem.l d0-d4,-(a7)            * d1.w/d2.w = Anfang
 bsr grmoveto                   * d3.w/d4.w = Ende
 asr #1,d4
 bsr drawt0                     * Endposition
 movem.l (a7)+,d0-d4
 rts

gr1p2:                          * Linienfolge zeichnen
 movem.l d0-d4,-(a7)            * a0 zerstrt, dadurch mehrere Tabellen
 move (a0)+,d7                  * hintereinander mglich
 subq #2,d7                     * a0 auf Tabelle
 movem.w (a0)+,d1/d2            * Anfang der Tabelle = Anzahl der Punkte
 bsr grmoveto                   * Dann Anfangspunkt, dann weitere Punkte
gr1p2a:
 movem.w (a0),d3/d4             * Nchste Koordinate
 asr #1,d4                      * Y/2
 bsr drawt0                     * Drawto ohne getxy
 movem.w (a0)+,d1/d2            * Endpunkt alter Linie ist Anfangspunkt
 asr #1,d2                      * neuer Linie; Y/2
 dbra d7,gr1p2a
 movem.l (a7)+,d0-d4
 rts

gr1p3:                          * Quardrat leer
 movem.l d3/d4/a0,-(a7)         * d1/d2 linke untere Ecke / d3 = Kantenlnge
 move d3,d4                     * Kantenlngen mssen positiv sein
 bsr gr1u1                      * Wie Rechteck leer mit gleichen Seitenlngen
 movem.l (a7)+,d3/d4/a0
 rts

gr1p4:                          * Quadrat voll
 movem.l d0-d4,-(a7)            * d1/d2 linke untere Ecke / d3 = Kantenlnge
 move d3,d4                     * d3 mu positiv sein
 bra.s gr1p60                   * Wie Rechteck voll mit gleichen Seitenlngen

gr1p5:                          * Rechteck leer
 movem.l d3/d4/a0,-(a7)         * d1/d2 linke untere Ecke d3/d4 = Kantenlngen
 bsr gr1u1                      * Kantenlngen mssen positiv sein
 movem.l (a7)+,d3/d4/a0
 rts

gr1p6:                          * Rechteck voll
 movem.l d0-d4,-(a7)            * d1/d2 linke untere Ecke d3/d4 = Kantenlngen
gr1p60:                         * Kantenlngen mssen positiv sein
 subq #1, d3
 move d2, d0
 add d4, d0
 asr #1, d0
 asr #1, d2
 sub d2, d0
 move d0, d4
 lea gdp.w,a6                   * GDP-Basis-Register
 add d1,d3                      * Breite
* asr #1,d2                      * Durch 2 wegen Bildschirmformat
* asr #1,d4                      * Wenn Hhe Null ist, dann OK
 beq.s gr1p6a
 subq #1,d4                     * Sonst minus 1 wegen DBRA
gr1p6a:                         * Hhe 0 und Hhe 1 sind jeweils eine Linie
 bsr gr1xline                   * Linie ziehen
 addq #1,d2                     * Y-Position erhhen
 dbra d4,gr1p6a
 movem.l (a7)+,d0-d4
 rts

gr1p7:                          * Kreis leer
 movem.l d0-d6/a0-a4,-(a7)      * d1/d2 Mittelpunkt / d3 = Radius
 move d3,d4                     * d3 mu positiv sein
 bsr gr1u2                      * Elipse leer aufrufen mit gleichen Radien
 movem.l (a7)+,d0-d6/a0-a4
 rts

gr1p8:                          * Kreis voll
 movem.l d0-d6/a0-a3,-(a7)      * d1/d2 Mittelpunkt / d3 = Radius
 move d3,d4                     * d3 mu positiv sein
 bsr gr1u3                      * Elipse voll aufrufen mit gleichen Radien
 movem.l (a7)+,d0-d6/a0-a3
 rts

gr1p9:                          * Elipse leer
 movem.l d0-d6/a0-a4,-(a7)      * d1/d2 Mittelpunkt / d3/d4 = Radien
 bsr gr1u2                      * Radien mssen positiv sein
 movem.l (a7)+,d0-d6/a0-a4
 rts

gr1p10:                         * Elipse voll
 movem.l d0-d6/a0-a3,-(a7)      * d1/d2 = Mittelpunkt / d3/d4 = Radien
 bsr gr1u3                      * Radien mssen positiv sein
 movem.l (a7)+,d0-d6/a0-a3
 rts

                                * ACHTUNG nicht mit Schwarz und XOR fllen
gr1p11:                         * Flche fllen ( Nur bei neuer GDP )
 btst.b #0,ioflag(a5)           * d1/d2 ist Punkt innerhalb der Flche
 beq carset                     * Fehler, da alte GDP
 cmp #511,d2
 bhi carset                     * Auerhalb des Bereichs
 cmp #511,d1
 bhi carset                     * Auerhalb des Bereichs
 movem.l d0-d6/a0,-(a7)
 lea page.w,a0                  * Auslese-Adresse
 lea gdp.w,a6                   * GDP-Basis-Register
 bsr grmoveto                   * Positionieren
 move.b gdp+1*cpu.w,d6          * Aktuelle Farbe holen
 ror.b #2,d6                    * Farbe in Bit 7
 and #$80,d6                    * Nur Bit 7 lassen
 bsr gr1p11h0                   * Punkt aus Bildschirmspeicher holen
 bne.s gr1p11fi                 * Wenn Farben gleich, dann Ende
 move #512,d5                   * Rechte Grenze
 move #-1,-(a7)                 * Endekennung Eckpunkte
 move d1,d3                     * X-Koordiante auch
 bsr.s gr1p11e                  * Linke Grenze holen
 movem.w d1/d2,-(a7)            * Merken (Auch Y-Koordinate)
 move d3,d1                     * X zurck
 bsr gr1p11f                    * Rechte Grenze holen
 move d1,-(a7)                  * Merken
gr1p11a:                        * Schleife
 move (a7)+,d3                  * Rechte Grenze vom Stack holen
 bmi.s gr1p11fi                 * Negativ, dann Stack leer und Ende
 movem.w (a7)+,d1/d2            * Linke Grenze und Y-Koordinate vom Stack holen
 bsr moveto
 bsr gr1p11h0                   * Punkt an aktueller Stelle holen
 bne.s gr1p11a                  * Schon gefllt, dann weiter
 bsr gr1xline                   * Linie ziehen
 move d1,d4                     * d1 merken
 addq.b #1,d2                   * Eine Reihe hoch
 bsr wait                       * Warten bis GDP fertig
 addq.b #1,gdp+$b*cpu.w         * GDP Y-Register auch erhhen
 beq.s gr1p11c                  * Obere Grenze erreicht
 bsr.s gr1p11e                  * Nach links, bis Farben ungleich
gr1p11b:
 bsr gr1p11g                    * Jetzt linke Grenze holen
 bcs.s gr1p11c                  * Fehler, keine linke Grenze gefunden
 movem.w d1/d2,-(a7)            * Werte merken
 bsr.s gr1p11f                  * Rechte Grenze holen
 move d1,-(a7)                  * Merken
 addq #1,d1                     * X-Koordinate erhhen
 cmp d1,d3                      * Nicht ber rechte Grenze hinaus
 bhi.s gr1p11b
gr1p11c:
 subq.b #2,d2                   * Eine Reihe tiefer (addq #1,d2 ausgleichen)
 cmp.b #255,d2                  * berlauf ?
 beq.s gr1p11a                  * Ja, dann nchste Linie
 subq.b #2,gdp+$b*cpu.w         * Y-Koordinate erniedrigen
 move d4,d1                     * d1 zurck
 bsr.s gr1p11e                  * Und wie oben
gr1p11d:
 bsr.s gr1p11g
 bcs.s gr1p11a
 movem.w d1/d2,-(a7)
 bsr.s gr1p11f
 move d1,-(a7)
 addq #1,d1
 cmp d1,d3
 bhi.s gr1p11d
 bra.s gr1p11a
gr1p11fi:
 movem.l (a7)+,d0-d6/a0         * Register zurck
 bra carres                     * OK, alles klar

gr1p11e:                        * Nach links suchen, bis Schreibfarbe<>Bildfarbe
 bsr.s gr1p11h                  * Punkt holen
 bne.s gr1p11e3                 * Ungleich, dann OK
 move.b (a0),d7                 * Punktreihe holen
 beq.s gr1p11e1                 * Wenn 0 oder $ff
 cmp.b #$ff,d7                  * dann auf 8-ter Grenze bringen
 bne.s gr1p11e2
gr1p11e1:
 and #$1f8,d1                   * Auf 8-ter Grenze
gr1p11e2:
 subq #1,d1                     * 1 zurck
 bpl.s gr1p11e                  * Positiv, dann wiederholen
 addq #1,d1                     * Sonst auf 0 und Ende
 rts
gr1p11e3:
 cmp #511,d1                    * Ganz rechts ?
 beq.s gr1p11e4                 * Ja, dann Ende
 addq #1,d1                     * Sonst 1 nach rechts
gr1p11e4:
 rts

gr1p11f:                        * Rechte Grenze suchen
 bsr.s gr1p11h                  * Punkt holen
 bne.s gr1p11f3                 * OK, Ende
 move.b (a0),d7                 * Punktreihe holen
 beq.s gr1p11f1
 cmp.b #$ff,d7
 bne.s gr1p11f2
gr1p11f1:
 and #$1f8,d1                   * Auf 8-ter Grenze bringen
 addq #7,d1                     * 7 dazu
gr1p11f2:
 addq #1,d1                     * 1 dazu
 cmp d5,d1                      * Rechte Grenze erreicht ?
 bne.s gr1p11f                  * Nein, dann weiter
gr1p11f3:
 subq #1,d1                     * 1 zurck
 rts

gr1p11g:
 move d1,-(a7)
gr1p11g0:
 bsr.s gr1p11h                  * Linke Grenze suchen
 beq.s gr1p11g3                 * OK, gefunden
 move.b (a0),d7                 * Punktreihe holen
 beq.s gr1p11g1
 cmp.b #$ff,d7
 bne.s gr1p11g2
gr1p11g1:
 and #$1f8,d1                   * Auf 8-ter Grenze bringen
 addq #7,d1                     * 7 dazu
gr1p11g2:
 addq #1,d1                     * 1 dazu
 cmp d5,d1                      * Rechte Grenze erreicht ?
 bne.s gr1p11g0                 * Nein, dann weitersuchen
 addq.l #2,a7                   * Stack abbauen
 bra carset                     * Fehler, keine linke Grenze gefunden
gr1p11g3:
 move (a7)+,d0                  * Anfangsprfpunkt nach d0
 cmp d3,d1                      * ber rechte Grenze hinaus ?
 bhi carset                     * Ja, Fehler
 cmp d0,d1
 bpl carres
 move d0,d1
 bra carres                     * OK, Linke Grenze korrekt gefunden

gr1p11h:                        * Einen Punkt prfen
 movep.w d1,8*cpu(a6)           * X-Koordinate setzen  ==> Nur fr 68000/68010
gr1p11h0:                       * Extra-Einsprung
 move.b #$f,(a6)                * Befehl fr Speicher auslesen
 move d1,d0                     * X-Koordinate holen
 and #7,d0                      * Nur 0 bis 7
gr1p11h1:
 btst.b #2,(a6)                 * Warten, bis GDP fertig
 beq.s gr1p11h1
 move.b (a0),d7                 * Wert holen
 lsl d0,d7                      * Bit fr Punkt an die richtige Stelle bringen
 and #$80,d7                    * Nur diesen Punkt lassen
 cmp.b d6,d7                    * Vergleich
 rts                            * Ende

gr1p12:                         * Schreibseite in aktueller Farbe lschen
                                * XORMODE wird dazu ausgeschaltet
 move.b gdpwpage(a5),d7         * Schreibseite
 lsl.b #2,d7
 or.b gdpwpage(a5),d7           * Wird gleich Leseseite gesetzt, damit alle
 lsl.b #4,d7                    * Seiten gelscht werden knnen
 bsr wait                       * Warten, bis GDP fertig
 move.b d7,page.w               * Daten bertragen
 or.b #4,gdp+1*cpu.w            * Screen kurz ausschalten
 move.b #$c,gdp.w               * Screen lschen
 bsr gr1page                    * Alte Seite setzen
 and.b #$fb,gdp+1*cpu.w         * Screen wieder anschalten
 rts

gr1p13:                         * Seite GDP setzen
 move.b d1,d7
 and.b #3,d7
 move.b d7,gdpvpage(a5)         * d1 = Leseseite
 move.b d2,d7
 and.b #3,d7
 move.b d7,gdpwpage(a5)         * d2 = Schreibseite
 bra gr1page

gr1p14:                         * Seite abfragen
 moveq #0,d1
 move.b gdpvpage(a5),d1         * Leseseite
 moveq #0,d2
 move.b gdpwpage(a5),d2         * Schreibseite
 rts

gr1p15:                         * Schreibfarbe + Verknpfungsmode
 and #1, d1                     * d1 ist Ergebnis Port 1 GDP
 move.b d1, gdpcolor(a5)        * Nur 0 oder 1
 move.b d2, d7
 and.b #1, d7
 move.b d7, gdpxor(a5)          * Nur an oder aus
 bsr gr1init                    * Alles setzen
 move.b gdp+1*cpu.w, d1         * Ergebnis Port 1 GDP
 rts

gr1p16:                         * Farbe und Verknpfungsmode abfragen
                                * Ergebnis d1 = Farbe / d2 = Verknpfungsmode
 moveq #0,d2                    * Langwort gltig
 move.b gdpxor(a5),d2           * d2.b ist Verknpfungsmode (0/1)
 moveq #0,d1                    * Langwort gltig
 move.b gdpcolor(a5),d1         * In d1.b ist Farbe
 rts

gr1p17:                         * Scrollwert setzen
 btst.b #0,ioflag(a5)           * d1 = Anzahl Punkte (In Zweierschritten)
 beq carset                     * Nur bei neuer GDP gltig
 move.b d1,d7
 and.b #$fe,d7                  * Nur in Zweier-Schritten
 move.b d7,gdpscroll(a5)        * Neuer Scroll
 not.b d7                       * Durch NOT gleiche Scrollrichtung wie bei COL
 addq #1, d7                    * Wert korregieren
 move.b d7,page1.w              * Neuer Wert
 bra carres                     * Es wird immer um minimal zwei Punkte gedreht

gr1p18:                         * Scroll abfragen, Scrollwert in d1
 moveq #0,d1                    * Langwort ist gltig
 move.b gdpscroll(a5),d1        * Y-Scroll-Wert aber nur als Byte
 rts

gr1p19:                         * Einen Punkt abfragen
 btst.b #0,ioflag(a5)           * Neue GDP ?
 beq carset                     * Nein, dann ist kein Auslesen mglich
 cmp #511,d2
 bhi carset                     * Auerhalb des Screens
 cmp #511,d1
 bhi carset                     * Auerhalb des Screens
 moveq #0,d3                    * Bit innerhalb Langwort gltig
 move d2,d7
 bsr grmoveto                   * d3 ist Ergebnis Punkt
 move.b #$f,gdp.w               * Befehl fr Speicher auslesen
 move d7,d2                     * d2 zurck
 move.b d1,d7                   * X-Koordinate nach d7
 and #7,d7                      * Auf 8-ter Grenze bringen
 addq #1,d7                     * 1 dazu wegen Schiebeoperation
gr1p19a:
 btst.b #2,gdp.w                * WAIT
 beq.s gr1p19a
 move.b page.w,d3               * Ein Byte aus Speicher holen
 rol.b d7,d3                    * Punkt an die richtige Stelle schieben
 not.b d3                       * Umdrehen, da invers im Speicher
 and.b #1,d3                    * Bit Null ist Punkt
 bra carres

gr1p20:                         * Hardcopy erstellen
 btst.b #0,ioflag(a5)           * In a0 steht Ziel
 beq carset                     * Nicht bei alter GDP
 movem.l d0-d3/a0,-(a7)
 moveq #2,d3                    * WAIT-Bit der GDP-Karte
 moveq #$f,d7                   * Befehl fr Speicher auslesen
 lea gdp.w,a6                   * GDP-Basis-Register
 bsr wait                       * Warten bis GDP fertig
 move.b #$e,(a6)                * Y-Pos auf Null
 move.b #1,gdp+$8*cpu.w         * X-High auf 1, da Hlfte gleich getauscht wird
 clr.b gdp+$9*cpu.w             * X-Low auf Null
 move #256-1,d2                 * 256 Zeilen
gr1p20a:
 subq.b #1,gdp+$b*cpu.w         * Y-Koordinate erniedrigen
 moveq #2-1,d1                  * X-Bereich in zwei Teile geteilt
gr1p20b:
 eori.b #1,gdp+$8*cpu.w         * X-Bereich wechseln
 moveq #32-1,d0                 * 32 Bytes holen
gr1p20c:
 move.b d7,(a6)                 * Speicher auslesen
gr1p20d:
 btst.b d3,(a6)                 * WAIT
 beq.s gr1p20d
 move.b page.w,(a0)             * Wert holen
 not.b (a0)+                    * Steht invers im Screen der GDP, deshalb NOT
 addq.b #8,gdp+$9*cpu.w         * 8 Punkte weiter
 dbra d0,gr1p20c
 dbra d1,gr1p20b
 dbra d2,gr1p20a
 movem.l (a7)+,d0-d3/a0
 bra carres                     * OK, alles klar

gr1p21:                         * Bild laden
 movem.l d0-d6/a0-a1,-(a7)      * In a0 steht Quelle (Mu gerade Adresse sein)
 moveq #2,d6                    * WAIT-Bit der GDP-Karte
 moveq #$80,d7                  * Befehl fr Punkt setzen
 lea gdp.w,a6                   * GDP-Basis fr WAIT
 lea gdp+9*cpu.w,a1
 clr d1                         * X-Koordinate
 bsr wait
 move.b #1,gdp+8*cpu.w          * X-High auf 1, da Hlfte gleich getauscht wird
 move.b #$e,(a6)                * Y auf Null
 move #256-1,d2                 * 256 Reihen
gr1p21a:
 btst.b d6,(a6)                 * Warten
 beq.s gr1p21a
 subq.b #1,gdp+$b*cpu.w
 moveq #2-1,d3                  * X geteilt in zwei Hlften wegen 256-Grenze
gr1p21b:
 btst.b d6,(a6)                 * Warten
 beq.s gr1p21b
 eori.b #1,gdp+$8*cpu.w         * Hlfte ndern
 moveq #8-1,d4                  * 8*32*2 = 512
gr1p21c:
 move.l (a0)+,d0                * 32 Pixel
 moveq #32-1,d5                 * 32 Bit
gr1p21d:
 btst d5,d0                     * Test, ob Punkt gesetzt
 beq.s gr1p21f                  * Nicht gesetzt
 move.b d1,(a1)                 * Neue X-Koordinate
gr1p21e:
 btst.b d6,(a6)                 * Warten
 beq.s gr1p21e
 move.b d7,(a6)                 * Punkt setzen
gr1p21f:
 addq.b #1,d1
 dbra d5,gr1p21d
 dbra d4,gr1p21c
 dbra d3,gr1p21b
 dbra d2,gr1p21a
 movem.l (a7)+,d0-d6/a0-a1      * Register zurck
 rts

gr1p23:                         * Textausgabe
 movem.l d0/d2,-(a7)
 asr #1,d2                      * Bildschirmaufbau beachten
 move.b d3,d0                   * Wie textprint, allerdings ist d3 die Gre
 bsr textprint
 movem.l (a7)+,d0/d2
 rts

gr1p24:                         * Zeichengenerator mit Voreinstellung
 move d2,d7                     * Y-Position merken
 bsr grmoveto                   * Ergebnis ist neue Position in d1/d2
 move.b d3,gdp+3*cpu.w          * Gre einstellen
 bsr progzge                    * Zeichen ausgeben
 move.b d3,d2                   * Gre nach d2
 lsr #4,d2
 and #$f,d2                     * Nur X-Vergrerung lassen
 beq.s gr1p24a
 moveq #16,d2                   * Null ist Vergrerung 16
gr1p24a:
 add d2,d2
 add d2,d1
 add d2,d2                      * Mal Zeichenbreite (6)
 add d2,d1                      * Neue Position
 move d7,d2                     * d2 auf alten Wert
 rts

gr1init:                        * Farbe, XOR-Mode und Seiten setzen
 move.b gdp+1*cpu.w,d7
 and #$fc,d7                    * Penmodus lschen
 ror.b #1,d7
 or.b gdpcolor(a5),d7           * Farbe dazu
 rol.b #1,d7
 addq.b #1,d7                   * Stift senken
 bsr wait                       * Warten bis GDP fertig
 move.b d7,gdp+1*cpu.w          * Farbe eingestellt

gr1page:
 move.b gdpwpage(a5),d7         * Schreibseite
 lsl.b #2,d7
 or.b gdpvpage(a5),d7           * Leseseite
 lsl.b #4,d7
 or.b gdpxor(a5),d7             * XOR-Mode
 bsr wait                       * Warten, bis GDP fertig
 move.b d7,page.w               * Alles setzen
 rts

grp31:                          * Grafik-Karte lesen
 moveq #0,d1                    * Langwort ist gltig
 move.b gdpcol(a5),d1
 rts

gr1u1:                          * Rechteck leer
* and #$fffe,d4
 subq #2,d4                     * Damit Hhe stimmt
 subq #1,d3                     * Damit Breite stimmt
 lea -150(a7),a0                * Stackbereich anlegen
 move #5,(a0)+                  * d1/d2 = linke untere Ecke
 move d1,(a0)+                  * d3/d4 = Seitenlngen (immer positiv)
 move d2,(a0)+                  * Erster Eckpunkt
 add d3,d1
 move d1,(a0)+
 move d2,(a0)+                  * Zweiter Eckpunkt
 add d4,d2
 move d1,(a0)+
 move d2,(a0)+                  * Dritter Eckpunkt
 sub d3,d1
 move d1,(a0)+
 move d2,(a0)+                  * Vierter Eckpunkt
 sub d4,d2
 move d1,(a0)+
 move d2,(a0)+                  * Zurck zum ersten Eckpunkt -> Viereck fertig
 lea -150(a7),a0
 bra gr1p2                      * Befehl Linienfolge

gr1u2:                          * Elipse leer
 lea gdp.w,a6                   * GDP-Basis-Register
 lea -300(a7),a0                * Hier werden Kreisdaten abgelegt
 movea.l a0,a4
 asr #1,d2                      * Bildschirmformat
 move d3,(a0)
 add d1,(a0)+
 move d2,(a0)+                  * Punkt ganz rechts (Alpha = 0)
 move d1,(a0)
 sub d3,(a0)+
 move d2,(a0)+                  * Punkt ganz links (Alpha = 180)
 add d3,d1
 bsr moveto                     * Punkt ganz rechts
 movea.l a0,a1                  * Adresse merken
 move #-1,(a1)+                 * Bis jetzt keine Linie
 move d3,d1                     * X-Koordinate
 clr d2                         * Y-Koordinate
 lea sintab+2(pc),a2            * Tabelle fr Sinus
 lea sintab+180(pc),a3          * Tabelle fr Cosinus
 moveq #90-1,d7                 * Nur ein Viertel berechnen/Rest durch Spiegeln
gr1u2a:
 move -(a3),d5                  * Cossinus holen (Tabelle)
 muls d3,d5                     * Mal X-Radius
 asr.l #8,d5                    * Durch 256
 move (a2)+,d6                  * Sinus aus Tabelle
 muls d4,d6                     * Mal Y-Radius
 asr.l #8,d6                    * Durch 256
 asr.l #1,d6                    * Bildschirmaufbau beachten
 move d6,d0
 add d1,d0                      * d1/d2 alte Koordinaten
 sub d5,d0                      * d5/d6 neue Koordinaten
 sub d2,d0
 beq.s gr1u2c                   * Alte Koordinate = Neue Koordinate, dann weiter
 sub d5,d1                      * Sonst Linie zeichnen
 move.b d1,(a1)+                * Abstand X  Alter Punkt - Neuer Punkt
gr1u2b:
 btst.b #2,(a6)
 beq.s gr1u2b                   * Warten bis GDP fertig
 move.b d1,gdp+5*cpu.w          * Ins GDP DX-Register
 move d5,d1                     * X-Koordinate merken
 move d6,d0
 sub d2,d0                      * Abstand Y  Alter Punkt - Neuer Punkt
 move.b d0,(a1)+                * Merken
 move.b d0,gdp+7*cpu.w          * Und ins GDP DY-Register
 move.b #$13,(a6)               * Befehl Linie nach Links Oben
 move d6,d2                     * Y-Koordinate merken
 addq #1,(a0)                   * Ein Punkt mehr vorhanden
gr1u2c:
 dbra d7,gr1u2a
 tst (a0)
 bpl.s gr1u2d                   * Wenn positiv, dann mindestens ein Punkt
 moveq #$80,d0
 bra cmd                        * Sonst nur Punkt setzen
gr1u2d:
 lea 4(a4),a0                   * Adresse Anfangskoordinate
 moveq #$11,d0                  * Richtung
 bsr.s gr1u2e                   * 2. Kreisbogen malen
 moveq #$15,d0                  * Richtung
 bsr.s gr1u2e                   * 3. Kreisbogen malen
 movea.l a4,a0                  * Adresse Anfangskoordinaten
 moveq #$17,d0                  * Richtung
gr1u2e:                         * Letzter Kreisbogen
 movem (a0),d1/d2
 bsr moveto                     * Anfangskoordinate
 lea 8(a4),a1                   * Adresse Linien
 move (a1)+,d1                  * Anzahl Linien-1
gr1u2f:
 btst.b #2,(a6)
 beq.s gr1u2f                   * Warten bis GDP fertig
 move.b (a1)+,gdp+5*cpu.w       * Delta-X
 move.b (a1)+,gdp+7*cpu.w       * Delta-Y
 move.b d0,(a6)                 * Befehl Linie ausgeben
 dbra d1,gr1u2f                 * Nchste Linie
 rts

gr1u3:                          * Elipse ausgefllt
 lea gdp.w,a6                   * GDP-Basis-Register
 lea -100(a7),a0                * Merker Palt
 lea -104(a7),a1                * Merker Pneu
 asr #1,d2
 move d1,d5                     * Merker X
 move d2,d6                     * Merker Y
 add d3,d1
 movem d1/d2,(a0)               * Erste Koordinate fr Vergleich merken
 move d3,d7
 neg d3
 add d5,d3
 bsr.s gr1xline                 * Linie durch Mittelpunkt, da Spezialfall
 move d7,d3                     * denn diese Linie wird nicht berechnet
 lea sintab+2(pc),a2            * Tabelle fr Sinus
 lea sintab+180(pc),a3          * Tabelle fr Cosinus
 moveq #90-1,d7                 * 90 Grad
gr1u3a:
 move -(a3),d1                  * Sinus
 muls d3,d1                     * Mal X-Radius
 asr.l #8,d1                    * Durch 256
 add d5,d1                      * X-Koordinate berechnet
 move (a2)+,d2                  * Cosinus
 muls d4,d2                     * Mal Y-Radius
 asr.l #8,d2                    * Durch 256
 asr.l #1,d2                    * Bildschirmformat
 add d6,d2                      * Y-Koordinate berechnet
 movem d1/d2,(a1)               * X,Y merken
gr1u3b:
 move d2,d0
 sub 2(a0),d0
 beq.s gr1u3d                   * Wenn Delta-Y = 0 , dann Linie nicht zeichnen
 cmp #1,d0
 beq.s gr1u3c                   * Wenn 1, dann zeichnen
 add (a0),d1                    * Sonst arithmetisches Mittel von letzter und
 asr #1,d1                      * dieser Koordinate bis Abstand nur noch 1,
 add 2(a0),d2                   * dadurch werden einige MULS und LSR eingespart
 asr #1,d2
 bra.s gr1u3b                   * Wiederholen bis Abstand zu Yalt = 1
gr1u3c:
 move d3,-(a7)                  * Abstand ist 1, jetzt Linie zeichnen
 movem d1/d2,(a0)               * Koordinaten merken
 move d5,d3
 add d5,d3
 sub d1,d3                      * Spiegelung an X-Achse
 bsr.s gr1xline                 * Linie parallel zur X-Achse
 neg d2
 add d6,d2
 add d6,d2                      * d2 an Mittelpunkt gespiegelt
 bsr.s gr1xline                 * Linie parallel zur X-Achse
 move (a7)+,d3
 move 2(a1),d2
 cmp 2(a0),d2                   * Wenn erste Y-Position und entgltig Berechnet
 beq.s gr1u3d                   * bereinstimmen, dann nchsten Punkt berechnen
 move (a1),d1                   * Sonst nchsten Punkt mit alten Winkel
 bra.s gr1u3b
gr1u3d:
 dbra d7,gr1u3a                 * Neuer Winkel
 rts

gr1xline:                       * d1/d2/d3   d0 darf zerstrt werden
 move d3,d0                     * Delta-X
 sub d1,d0                      * berechnen
 bpl.s gr1xla                   * Wenn positiv, dann weiter
 exg d1,d3                      * d1 und d3 tauschen
 neg d0                         * Delta-X mu positiv sein
gr1xla:
 bsr moveto                     * Positionieren
gr1xlb:
 cmp #255,d0                    * Zu gro fr eine Linie ?
 bhi.s gr1xld                   * Ja, dann teilen
gr1xlc:
 btst.b #2,(a6)                 * WAIT
 beq.s gr1xlc
 move.b d0,gdp+5*cpu.w          * Lnge
 move.b #$10,(a6)               * Linie zeichnen
 rts

gr1xld:
 move d0,-(a7)                  * d0 merken
gr1xle:
 asr #1,d0
 cmp #255,d0                    * Immer noch zur gro ?
 bhi.s gr1xle                   * Ja, dann weiter teilen
gr1xlf:
 btst.b #2,(a6)                 * WAIT
 beq.s gr1xlf
 move.b d0,gdp+5*cpu.w          * Lnge
 move.b #$10,(a6)               * Linie zeichnen
 neg d0
 add (a7)+,d0                   * Rest der Linie
 bra.s gr1xlb                   * Wiederholen

gr1ap16:
 moveq #16-1, d3                * 16 Pixel
gr1ap16a:
 tst d1                         * X-Koordinate
 bpl.s gr1ap16b                 * in Darstellungsbereich
 lsl #1, d0
 addq #1, d1                    * sonst nchstes Pixel
 dbra d3, gr1ap16a
 bra.s gr1ap16f                 * hier Ende
gr1ap16b:
 cmp #512, d1                   * rechter Rand berschritten?
 bge.s gr1ap16f                 * dann Ende
 movep.w d1, 0(a1)              * Neue X-Koordinate -- Nur fr 68000/68010
 lsl #1, d0                     * ein Pixel in Carry
 bcc.s gr1ap16d                 * Schwarz
gr1ap16c:
 btst.b d6, (a6)                * Warten
 beq.s gr1ap16c
 bset.b #1, (a3)                * Schreibstift
 bra.s gr1ap16e
gr1ap16d:
 btst.b d6, (a6)                * Warten
 beq.s gr1ap16d
 bclr.b #1, (a3)                * Lschstift
gr1ap16e:
 move.b d7, (a6)                * Punkt setzen
 addq #1, d1
 dbra d3, gr1ap16b              * nchster Punkt
gr1ap16f:
 rts

gr1p26:                         * Sprite schreiben
 btst.b #0,ioflag(a5)           * In a0 steht Ziel
 beq carset                     * Nicht bei alter GDP
 movem.l d0-d6/a0-a6, -(a7)
 move.b gdpxor(a5), d0          * XOR-Mode
 move d0, -(a7)                 * auf Stack retten
 lea gdp.w, a6                  * GDP-Basis fr WAIT
 lea gdp+8*cpu.w, a4            * X-Register GDP
 lea gdp+1*cpu.w, a3            * GDP-CTRL1
 move d3, d7                    * Optionen retten
 move.b (a1)+, d6               * Maske
 move.b (a1)+, d5               * Spriteart
 sub (a1)+, d1                  * X-Koordinate - X-Offset
 sub (a1)+, d2                  * Y-Koordinate - Y-Offset
 asr #1, d2                     * auf 0..255
 move.b (a1)+, d3               * X-Scalierung
 move.b (a1)+, d4               * Y-Scalierung
gr1p26a:
 addq #8, a1                    * +8 um auf Maske bzw. Bild zu kommen
 btst.b #0, d7                  * Hintergrund speichern?
 bne.s gr1p26b                  * nein!
 bsr gr1sb                      * Speicherroutine
gr1p26b:
 tst.b d6                       * Maske?
 bne gr1p26o                    * nein
 movea.l a1, a0                 * fr Maske
 moveq #8, d0                   * 8 Zeilen
 asl d4, d0                     * *Y-Scalierung
 moveq #2, d7                   * 2 Byte
 asl d3, d7                     * *X-Scalierung
 mulu d7, d0                    * Gre der Maske
 adda d0, a1                    * hier Bildpointer
gr1p26m:                        * mit Maske 2 Farben
 move.b gdpwpage(a5),d6         * Schreibseite
 lsl.b #2,d6
 or.b gdpvpage(a5),d6           * Leseseite
 lsl.b #4,d6
 or.b gdpxor(a5),d6             * XOR-Mode
 moveq #8, d0                   * 8 Zeilen
 lsl d4, d0                     * *Y-Scalierung
 subq #1, d0                    * -1 als Zhler
 move d0, d4                    * nach d4
 btst.b #0, d5                  * 2 oder 16 Farben
 bne gr1p26n                    * 16 Farben dort
gr1p26m1:
 tst d2                         * Y >=0 ?
 bpl.s gr1p26m2                 * ja, dann Ausgabe
 moveq #2, d0                   * 2 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a1                  * Bild auf nchste Zeile
 adda.l d0, a0                  * Maske auch auf
 addq #1, d2                    * nchste Zeile
 dbra d4, gr1p26m1
 bra gr1p26x                    * Ende
gr1p26m2:
 cmp #256, d2                   * oberer Rand berschritten?
 bge gr1p26x                    * Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 move d1, -(a7)                 * X-Koordinate retten
 moveq #2, d5                   * 2 Byte
 lsl d3, d5                     * *X-Scalierung
 subq #1, d5                    * -1 als Zhler
gr1p26m3:
 move (a0)+, d0                 * 16 Masken-Pixel
 swap d0
 move (a1)+, d0                 * 16 Bild-Pixel laden
 moveq #16-1, d7                * 16 Bits
gr1p26m4:
 tst d1                         * X-Koordinate
 bpl.s gr1p26m5                 * in Darstellungsbereich
 lsl.l #1, d0
 addq #1, d1                    * sonst nchstes Pixel
 dbra d7, gr1p26m4
 bra.s gr1p26m9                 * hier Ende
gr1p26m5:
 cmp #512, d1                   * rechter Rand berschritten?
 bge.s gr1p26m9                 * dann Ende
gr1p26m6:
 btst.b #2, (a6)                * Warten
 beq.s gr1p26m6
 movep.w d1, 0(a4)              * Neue X-Koordinate -- Nur fr 68000/68010
 lsl #1, d0                     * Pixel-Bit
 bcs.s gr1p26mb                 * gesetzt
 swap d0
 lsl #1, d0                     * Masken-Bit
 bcc.s gr1p26ma                 * wenn 0, dann Pixel belassen
 bra.s gr1p26m7                 * sonst Hintergrundfarbe
gr1p26mb:
 swap d0
 lsl #1, d0                     * Masken-Bit
 bcs.s gr1p26mc                 * Vordergrundfarbe setzen
 btst.b #0, d6                  * XOR-Mode
 bne.s gr1p26md                 * ist gesetzt, dann Pixel ausgeben
 bset.b #0, d6                  * XOR setzen
 move.b d6, page.w              * und ausgeben
 bra.s gr1p26md
gr1p26mc:
 btst.b #0, d6                  * XOR-Mode
 beq.s gr1p26md                 * ist gelscht, dann weiter
 bclr.b #0, d6                  * XOR-Mode lschen
 move.b d6, page.w              * und ausgeben
gr1p26md:
 bset.b #1, (a3)                * Schreibstift
 bra.s gr1p26m8
gr1p26m7:
 bclr.b #1, (a3)                * Lschstift
gr1p26m8:
 move.b #$80, (a6)              * Punkt setzen
gr1p26ma:
 swap d0                        *
 addq #1, d1
 dbra d7, gr1p26m5              * nchster Punkt
gr1p26m9:
 dbra d5, gr1p26m3              * nchsten 2 Byte
 addq #1, d2                    * nchste Zeile
 move (a7)+, d1                 * X-Koordinate zurck
 dbra d4, gr1p26m2
 bra gr1p26x                    * hier Ende
gr1p26n:                        * mit Maske 16 Farben
gr1p26n1:
 tst d2                         * Y >=0 ?
 bpl.s gr1p26n2                 * ja, dann Ausgabe
 moveq #8, d0                   * 8 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a1                  * Bild auf nchste Zeile
 moveq #2, d0                   * 2 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a0                  * Maske auf nchste Zeile
 addq #1, d2                    * Y auch auf nchste Zeile
 dbra d4, gr1p26n1
 bra gr1p26x                    * Ende
gr1p26n2:
 cmp #256, d2                   * oberer Rand berschritten?
 bge gr1p26x                    * Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 move d1, -(a7)                 * X-Koordinate retten
 moveq #8, d5                   * 8 Byte
 lsl d3, d5                     * *X-Scalierung
 subq #1, d5                    * -1 als Zhler
 swap d2                        *
gr1p26n3:
 move.b (a0)+, d2               * 8 Masken-Pixel
 move.l (a1)+, d0               * 8 Bild-Pixel laden
 moveq #8-1, d7                 * 8 Nibble
gr1p26n4:
 tst d1                         * X-Koordinate
 bpl.s gr1p26n5                 * in Darstellungsbereich
 lsl.b #1, d2                   * Maske
 lsl.l #4, d0                   * Pixel
 addq #1, d1                    * sonst nchstes Pixel
 dbra d7, gr1p26n4
 bra.s gr1p26n9                 * hier Ende
gr1p26n5:
 cmp #512, d1                   * rechter Rand berschritten?
 bge.s gr1p26n9                 * dann Ende
gr1p26n6:
 btst.b #2, (a6)                * Warten
 beq.s gr1p26n6
 movep.w d1, 0(a4)              * Neue X-Koordinate -- Nur fr 68000/68010
 swap d1
 rol.l #4, d0                   * Pixel-Bit
 move.b d0, d1
 and.b #$01, d1                 * nur Bit #0 lassen
 bne.s gr1p26nb                 * gesetzt
 lsl.b #1, d2                   * Masken-Bit
 bcc.s gr1p26na                 * wenn 0, dann Pixel belassen
 bra.s gr1p26n7                 * sonst Hintergrundfarbe
gr1p26nb:
 lsl.b #1, d2                   * Masken-Bit
 bcs.s gr1p26nc                 * Vordergrundfarbe setzen
 btst.b #0, d6                  * XOR-Mode
 bne.s gr1p26nd                 * ist gesetzt, dann Pixel ausgeben
 bset.b #0, d6                  * XOR setzen
 move.b d6, page.w              * und ausgeben
 bra.s gr1p26nd
gr1p26nc:
 btst.b #0, d6                  * XOR-Mode
 beq.s gr1p26nd                 * ist gelscht, dann weiter
 bclr.b #0, d6                  * XOR-Mode lschen
 move.b d6, page.w              * und ausgeben
gr1p26nd:
 bset.b #1, (a3)                * Schreibstift
 bra.s gr1p26n8
gr1p26n7:
 bclr.b #1, (a3)                * Lschstift
gr1p26n8:
 move.b #$80, (a6)              * Punkt setzen
gr1p26na:
 swap d1                        *
 addq #1, d1
 dbra d7, gr1p26n5              * nchster Punkt
gr1p26n9:
 dbra d5, gr1p26n3              * nchsten 8 Pixel
 swap d2
 addq #1, d2                    * nchste Zeile
 move (a7)+, d1                 * X-Koordinate zurck
 dbra d4, gr1p26n2
 bra gr1p26x                    * hier Ende
gr1p26o:                        * ohne Maske, 2 Farben
 clr.b gdpxor(a5)               * kein XOR
 bsr gr1page                    * Seite und XOR-Modus setzen
 moveq #8, d0                   * 8 Zeilen
 lsl d4, d0                     * *Y-Scalierung
 subq #1, d0                    * -1 als Zhler
 move d0, d4                    * nach d4
 btst.b #0, d5                  * 2 oder 16 Farben
 bne.s gr1p26p                  * 16 Farben dort
gr1p26o1:
 tst d2                         * Y >=0 ?
 bpl.s gr1p26o2                 * ja, dann Ausgabe
 moveq #2, d0                   * 2 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a1
 addq #1, d2                    * nchste Zeile
 dbra d4, gr1p26o1
 bra gr1p26x                    * Ende
gr1p26o2:
 cmp #256, d2                   * rechter Rand berschritten?
 bge gr1p26x                    * Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 move d1, -(a7)                 * X-Koordinate retten
 moveq #2, d5                   * 2 Byte
 lsl d3, d5                     * *X-Scalierung
 subq #1, d5                    * -1 als Zhler
gr1p26o3:
 move (a1)+, d0                 * 16 Pixel laden
 moveq #16-1, d7                * 16 Bits
gr1p26o4:
 tst d1                         * X-Koordinate
 bpl.s gr1p26o5                 * in Darstellungsbereich
 lsl #1, d0
 addq #1, d1                    * sonst nchstes Pixel
 dbra d7, gr1p26o4
 bra.s gr1p26o9                 * hier Ende
gr1p26o5:
 cmp #512, d1                   * rechter Rand berschritten?
 bge.s gr1p26o9                 * dann Ende
gr1p26o6:
 btst.b #2, (a6)                * Warten
 beq.s gr1p26o6
 movep.w d1, 0(a4)              * Neue X-Koordinate -- Nur fr 68000/68010
 lsl #1, d0                     * ein Pixel in Carry
 bcc.s gr1p26o7                 * Schwarz
 bset.b #1, (a3)                * Schreibstift
 bra.s gr1p26o8
gr1p26o7:
 bclr.b #1, (a3)                * Lschstift
gr1p26o8:
 move.b #$80, (a6)              * Punkt setzen
 addq #1, d1
 dbra d7, gr1p26o5              * nchster Punkt
gr1p26o9:
 dbra d5, gr1p26o3              * nchsten 2 Byte
 addq #1, d2                    * nchste Zeile
 move (a7)+, d1                 * X-Koordinate zurck
 dbra d4, gr1p26o2
 bra.s gr1p26x                  * hier Ende
gr1p26p:                        * ohne Maske 16 Farben
gr1p26p1:
 tst d2                         * Y >=0 ?
 bpl.s gr1p26p2                 * ja, dann Ausgabe
 moveq #8, d0                   * 8 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a1
 addq #1, d2                    * nchste Zeile
 dbra d4, gr1p26p1
 bra.s gr1p26x                  * Ende
gr1p26p2:
 cmp #256, d2                   * rechter Rand berschritten?
 bge.s gr1p26x                  * Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 move d1, -(a7)                 * X-Koordinate retten
 moveq #8, d5                   * 8 Byte
 lsl d3, d5                     * *X-Scalierung
 subq #1, d5                    * -1 als Zhler
gr1p26p3:
 move.b (a1)+, d0               * 2 Pixel laden
 moveq #2-1, d7                 * a 4 Bits
gr1p26p4:
 tst d1                         * X-Koordinate
 bpl.s gr1p26p5                 * in Darstellungsbereich
 rol.b #4, d0
 addq #1, d1                    * sonst nchstes Pixel
 dbra d7, gr1p26p4
 bra.s gr1p26p9                 * hier Ende
gr1p26p5:
 cmp #512, d1                   * rechter Rand berschritten?
 bge.s gr1p26p9                 * dann Ende
 movep.w d1, 0(a4)              * Neue X-Koordinate -- Nur fr 68000/68010
 rol.b #4, d0                   * Pixel ind Bit #3-0
 move.b d0, d6                  * nach d6
 and.b #$01, d6                 * nur akt. Pixel lassen Bit #0
 beq.s gr1p26p7                 * Schwarz
 bset.b #1, (a3)                * Schreibstift
 bra.s gr1p26p8
gr1p26p7:
 bclr.b #1, (a3)                * Lschstift
gr1p26p8:
 btst.b #2, (a6)                * Warten
 beq.s gr1p26p8
 move.b #$80, (a6)              * Punkt setzen
 addq #1, d1
 dbra d7, gr1p26p5              * nchster Punkt
gr1p26p9:
 dbra d5, gr1p26p3              * nchstes Byte
 addq #1, d2                    * nchste Zeile
 move (a7)+, d1                 * X-Koordinate zurck
 dbra d4, gr1p26p2
gr1p26x:
 move (a7)+, d0
 move.b d0, gdpxor(a5)
 bsr gr1page                    * Seite und XOR-Modus setzen
 movem.l (a7)+, d0-d6/a0-a6
 bra carres                     * OK, alles klar

gr1sb:                          * Hintergrund speichern
 movem.l d0-d6/a0/a3, -(a7)
 lea page.w, a3                 * Seiten Register
 move.b #0, (a0)+               * Spriteart = GDP-COL
 move.b gdpwpage(a5), (a0)+     * Schreibseite
 move d1, (a0)+                 * X-Koordinate
 move d2, (a0)+                 * Y-Koordinate
 move.b d3, (a0)+               * X-Scalierung
 move.b d4, (a0)+               * Y-Scalierung
 addq #8, a0                    * Offset fr Bilddaten
 moveq #8, d5                   * 8 Zeilen
 lsl d4, d5                     * * Y-Scalierung
 subq #1, d5                    * -1 als Zhler
gr1sba:
 tst d2                         * Y >=0 ?
 bpl.s gr1sbb                   * ja, dann Ausgabe
 moveq #3, d0                   * 3 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a0
 addq #1, d2                    * nchste Zeile
 dbra d5, gr1sba
 bra.s gr1sbx                   * Ende
gr1sbb:
 cmp #256, d2                   * oberer Rand berschritten?
 bge gr1sbx                     * dann Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 or #$fff1, d1                  * X auf 8er Adresse bringen
 move d1, -(a7)                 * X-Koordinate sichern
 moveq #1, d6
 asl d3, d6                     * 1*X-Scalierung
 subq #1, d6                    * -1 als Zhler
gr1sbc:
 moveq #3-1, d4                 * max. 2*9 Punkte
gr1sbd:
 movep.w d1, 0(a4)              * X-Koordinate setzen --- Nur fr 68000/68010
 move.b #$f, (a6)               * Befehl fr Speicher auslesen
gr1sbe:
 btst.b #2, (a6)                * WAIT
 beq.s gr1sbe
 move.b (a3), d0                * 8 Pixel holen
 not.b d0                       * inventiert im Grafikspeicher
 move.b d0, (a0)+               * und speichern
 addq #8, d1                    * nchsten Pixel
 dbra d4, gr1sbd
 dbra d6, gr1sbc                * bei Scalierung
 move (a7)+, d1                 * X-Koordinate zurck
 addq #1, d2                    * nchste Zeile
 dbra d5, gr1sbb
gr1sbx:
 movem.l (a7)+, d0-d6/a0/a3
 rts

gr1p27:                         * Sprite lschen
 movem.l d0-d6/a0-a4, -(a7)     * a0 zeigt auf Speicher
 move.b (a0)+, d0               * Spriteart
 cmp.b #0, d0                   * GDP-SW-Sprite 32 bis 1544 Byte gro
 bne gr1p27d                    * sonst Fehler
 move.b gdpwpage(a5), d0        * Schreibseite
 lsl #8, d0                     * ins obere Byte
 move.b gdpxor(a5), d0          * XOR-Mode
 move d0, -(a7)                 * auf Stack retten
 move.b (a0)+, gdpwpage(a5)     * alte Schreibseite
 clr.b gdpxor(a5)               * XOR-Modus lschen
 bsr gr1page                    * Seite und XOR-Modus setzen
 move (a0)+, d1                 * X-Koordinate
 move (a0)+, d2                 * Y-Koordinate
 move.b (a0)+, d3               * X-Scalierung
 move.b (a0)+, d4               * Y-Scalierung
 addq #8, a0                    * +8 um auf Bilddaten zu kommen
 moveq #8, d5                   * 8 Zeilen
 lsl d4, d5                     * * Y-Scalierung
 subq #1, d5                    * -1 als Zhler
 move d1, d0                    * fr Shiftfaktor
 and #$7, d0                    * nur 0-7
 moveq #8, d4
 sub d0, d4                     * 8-Shift
 moveq #2, d6                   * WAIT-Bit der GDP-Karte
 moveq #$80, d7                 * Befehl fr Punkt setzen
 lea gdp.w, a6                  * GDP-Basis fr WAIT
 lea gdp+1*cpu.w, a3            * GDP-CTRL1
 lea gdp+8*cpu.w, a1            * X-Register GDP
 lea gdp+$b*cpu.w, a4           * Y-Register LSB
gr1p27a:
 tst d2                         * Y >=0 ?
 bpl.s gr1p27b                  * ja, dann Ausgabe
 addq #1, d2                    * sonst nchste Zeile
 moveq #3, d0                   * 3 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a0
 dbra d5, gr1p27a
 bra.s gr1p27d                  * hier Ende
gr1p27b:
 cmp #256, d2                   * oberer Rand berschritten?
 bge.s gr1p27d                  * ja, dann Ende
 move d3, -(a7)                 * X-Scale retten
 move d1, -(a7)                 * X retten
 moveq #1, d0                   * 1 * 3 Byte
 lsl d3, d0                     * * X-Scale
 subq #1, d0                    * -1 als X_Scale Zhler
 move d0, d3                    * in d3
 move.b d2, (a4)                * Y-Koordinaten setzen
gr1p27b1:
 move.b (a0)+, d0               * 1. Byte
 swap d0                        * in Bits #23-16
 move.b (a0)+, d0               * 2. Byte
 lsl #8, d0                     * in Bits #15-8
 move.b (a0)+, d0               * 3. Byte in Bits #7-0
 lsr.l d4, d0                   * Pixel in Position schieben
 move d3, -(a7)                 * X-Scale Zhler retten
 bsr gr1ap16                    * und ausgeben
 move (a7)+, d3                 * X-Scale Zhler zurck
 dbra d3, gr1p27b1
 addq #1, d2                    * Y+1
 move (a7)+, d1                 * X zurck
 move (a7)+, d3                 * X-Scale zurck
 dbra d5, gr1p27b               * nchste Zeile
gr1p27c:
 move (a7)+, d0
 move.b d0, gdpxor(a5)
 lsr #8, d0
 move.b d0, gdpwpage(a5)
 bsr gr1page                    * Seite und XOR-Modus setzen
 bset.b #1, (a3)                * Schreibstift muss gesetzt werden
 movem.l (a7)+, d0-d6/a0-a4
 bra carres
gr1p27d:                        * Fehler
 movem.l (a7)+, d0-d6/a0-a4
 bra carset

gr1p32:                         * Bereich speichern
 movem.l d0-d6/a0/a2-a4/a6, -(a7)
 lea page.w, a3                 * Seiten Register
 lea gdp.w, a6                  * GDP-Basis fr WAIT
 lea gdp+8*cpu.w, a2            * X-Register GDP
 lea gdp+$b*cpu.w, a4           * Y-Register LSB
 move.l #$1FF, d0               * max. 511
 and.l d0, d1
 and.l d0, d2
* and.l d0, d3
* and.l d0, d4
 asr #1, d2                     * Y auf 0..255
 asr #1, d4                     * Hhe auf 0..255
 subq #1, d4                    * als Zhler
 move.b #-1, d5                 * Maske1
 move.b d5, d6                  * Maske2
 not.b d6
 move d1, d7                    * X-Koordinate
 or #$fff1, d1                  * Auf 8-Grenze bringen
 and #7, d7                     * Rest?
 beq.s gr1p32a                  * kein Rest vorhanden
 lsl.b d7, d5                   * Maske1
 move.b d5, d6
 not.b d6                       * Maske2
gr1p32a:
 move.b d2, (a4)                * Y-Koordinate setzen
 swap d2                        * Y retten
 clr d2                         * Vorsichtshalber lschen
 swap d4                        * Hhe retten
 clr d4                         * Vorsichtshalber lschen
 move d1, -(a7)                 * X-Koordinate sichern
 move d3, -(a7)                 * Breitenzhler sichern
 tst.b d7                       * Auf 8er Grenze?
 beq.s gr1p32c                  * Ja
                                * 1. Durchlauf wenn nicht auf 8er Adresse
 movep.w d1, 0(a2)              * X-Koordinate setzen --- Nur fr 68000/68010
 move.b #$f, (a6)               * Befehl fr Speicher auslesen
gr1p32b:
 btst.b #2, (a6)                * WAIT
 beq.s gr1p32b
 move.b (a3), d2                * erster Zugriff 8 Pixel holen
 not.b d2                       * invertieren
 lsl.b d7, d2                   * in Position schieben
 addq #8, d1                    *
gr1p32c:                        * Hier 1. Durchlauf 8er Adresse
 and.b d5, d2
 movep.w d1, 0(a2)              * X-Koordinate setzen --- Nur fr 68000/68010
 move.b #$f, (a6)               * Befehl fr Speicher auslesen
gr1p32d:
 btst.b #2, (a6)                * WAIT
 beq.s gr1p32d
 move.b (a3), d0                * 8 Pixel holen
 not.b d0                       * invertieren
 rol.b d7, d0                   * in Position schieben
 move.b d0, d4
 and.b d6, d0
 or.b d2, d0
 move.b d0, (a0)+               * und speichern
 move.b d4, d2
 addq #8, d1
 subq #8, d3
 bpl.s gr1p32c                  * nchste 8er Gruppe
 move (a7)+, d3                 * Breitenzhler zurck
 move (a7)+, d1                 * X-Koordinate zurck
 swap d2                        * Y-Koordinate zurck
 swap d4                        * Hhe zurck
 addq #1, d2                    * nchste Zeile
 dbra d4, gr1p32a
gr1p32x:
 movem.l (a7)+, d0-d6/a0/a2-a4/a6
 rts

gr1p33:                         * Bereich schreiben
 movem.l d0-d7/a0/a2-a4/a6, -(a7)
 lea gdp.w, a6                  * GDP-Basis fr WAIT
 lea gdp+8*cpu.w, a2            * X-Register GDP
 lea gdp+1*cpu.w, a3            * GDP-CTRL1
 lea gdp+$b*cpu.w, a4           * Y-Register LSB
 move.l #$1FF, d0               * max. 511
 and.l d0, d1
 and.l d0, d2
* and.l d0, d3
* and.l d0, d4
 asr #1, d2                     * Y auf 0..255
 asr #1, d4                     * Hhe auf 0..255
 subq #1, d4                    * Hhenzhler
 subq #1, d3                    * Breitenzhler
 moveq #2, d6                   * Bit frs Warten
 move.b #$80, d7                * Punkt setzen
gr1p33a:
 move.b d2, (a4)                * Y-Koordinate ausgeben
 movem d1/d3, -(a7)             * X-Koordinate u. Breitenzhler retten
gr1p33b:
 moveq #8-1, d5                 * Pixel in Byte
 move.b (a0)+, d0               * 8 Pixel
gr1p33c:
 movep.w d1, 0(a2)              * Neue X-Koordinate -- Nur fr 68000/68010
 lsl.b #1, d0                   * ein Pixel in Carry
 bcc.s gr1p33e                  * Schwarz
gr1p33d:
 btst.b d6, (a6)                * Warten
 beq.s gr1p33d
 bset.b #1, (a3)                * Schreibstift
 bra.s gr1p33f
gr1p33e:
 btst.b d6, (a6)                * Warten
 beq.s gr1p33e
 bclr.b #1, (a3)                * Lschstift
gr1p33f:
 move.b d7, (a6)                * Punkt setzen
 addq #1, d1
 subq #1, d3
 bmi.s gr1p33g                  * Zeile fertig
 dbra d5, gr1p33c               * nchster Punkt
 bra.s gr1p33b
gr1p33g:
 movem (a7)+, d1/d3             * X-Koordinate u. Breitenzhler zurck
 addq #1, d2                    * nchstes Y
 dbra d4, gr1p33a
 bset.b #1, (a3)                * wieder auf Schreibstift!!!
 movem.l (a7)+, d0-d7/a0/a2-a4/a6
 rts
 s
               * nchste Zeile
 move (a7)+, d1                 * X-Koordinate zurck
